IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_SCA_ValidarUltCuotaPaga') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_SCA_ValidarUltCuotaPaga
END
GO

CREATE FUNCTION [dbo].[CF_SCA_ValidarUltCuotaPaga](@pId_Cliente INT, @pId_Acceso SMALLINT, @pFecha DATETIME)
RETURNS TINYINT
AS
BEGIN
DECLARE @Flag_UCP				TINYINT
DECLARE @Ult_Cuota_Paga			DATETIME
DECLARE @Flag_Ult_Cuota_Paga	TINYINT
DECLARE @Dias_Gracia			INT

SET @Flag_UCP				= 0
SET @Flag_Ult_Cuota_Paga	= (SELECT ISNULL(Flag_Ult_Cuota_Paga, 0) FROM CD_Accesos WHERE Id_Acceso = @pId_Acceso)
SET @Dias_Gracia			= (SELECT ISNULL(Dias_Gracia, 0) FROM CD_Accesos WHERE Id_Acceso = @pId_Acceso)

IF(@Flag_Ult_Cuota_Paga <> 0)
BEGIN
	SET @Ult_Cuota_Paga = (SELECT ISNULL(Ult_Cuota_Paga, '19000101') FROM Clientes WHERE Id_Cliente = @pId_Cliente)
	
	IF(YEAR(CONVERT(DATE,(DATEADD(DAY,@Dias_Gracia,@Ult_Cuota_Paga)))) < YEAR(CONVERT(DATE,@pFecha)))
	BEGIN
		SET @Flag_UCP = 0
	END
	ELSE
	BEGIN
		IF(YEAR(CONVERT(DATE,(DATEADD(DAY,@Dias_Gracia,@Ult_Cuota_Paga)))) = YEAR(CONVERT(DATE,@pFecha)))
		BEGIN
			IF(MONTH(CONVERT(DATE,(@Ult_Cuota_Paga + @Dias_Gracia))) < MONTH(CONVERT(DATE,@pFecha)))
			BEGIN
				SET @Flag_UCP = 0
			END
			ELSE
			BEGIN
				SET @Flag_UCP = 1
			END
		END
		ELSE
		BEGIN
			SET @Flag_UCP = 1
		END
	END
	
	RETURN @Flag_UCP
END
ELSE
BEGIN
	SET @Flag_UCP = 0
	RETURN @Flag_UCP
END

RETURN ISNULL(@Flag_UCP, 0)

END